% Aufgabe 9.3 (d)

% Parameter fuer das AWP und die exakte Loesung:
b=-10^3;
C1=-1/(1-exp(b));
C2=-C1;

% verschiedene Schrittweiten:
a=7;
l=13;
H = 1./(2.^(a:l)+1);

errors=zeros(2,l-a+1); % Platz für die Fehler

for s=a:l
    
    % Berechnung mit den zentralen FDs (Y) bzw.
    % mit den rechtsseitigen FDs (Y2):
    [Y,Y_plus] = Aufgabe_9_3_b(b,H(s-a+1));
    
    % Berechnen der exakten Loeung ohne den Rand
    X=H(s-a+1):H(s-a+1):1-H(s-a+1);
    Y_exact=C1*exp(b*X)+C2;
    
    % Berechnung des Fehlers in der Maximumsnorm
    errors(1,s-a+1)=norm(Y-Y_exact',Inf);
    errors(2,s-a+1)=norm(Y_plus-Y_exact',Inf);
    
end

%Fehlerplot:
loglog(H,errors(1,:),'-o',H,errors(2,:),'-o');
legend('zentrale FDs','rechtsseitige FDs','Location','NorthWest');
title('Fehlerplot')
xlabel('Schrittweite h')
ylabel('Fehlerterm')
