% Aufgabe 9.3 (b)

% alle Matrizen und Vektoren sind hier im sparse Format!

function [Y,Y_plus] = Aufgabe_9_3_b(b,h)
% Y Approximation mit zentralen FDs
% Y2 Approximation mit rechtsseitigen FDs

n=(1/h)-1; % h=1/(n+1) bzw. n=1/h-1

% Berechnung mit den zentralen FDs:

% Hier wird L_h erzeugt:
di=2;
ri=-1-(b/2)*h;
si=-1+(b/2)*h;
% Variante über spdiags
Ltest = spdiags(repmat([ri,di,si],n,1), [-1 0 1], n,n)/h^2;
% Hier wird F-B_h (mit F=0) erzeugt:
Bh=spalloc(n,1,1);
Bh(end)=si/(h^2);
% Loesen des Gleichungssystems:
Y=-L\Bh;
    

% Berechnung mit den rechtsseitigen FDs:
    
% Hier wird L_h erzeugt:
di_plus=2-h*b;
ri_plus=-1;
si_plus=-1+h*b;
L_plus = spdiags(repmat([ri_plus, di_plus, si_plus],n,1), [-1 0 1], n,n)/h^2;
% Hier wird F-B^+_h (mit F=0) erzeugt:
Bh_plus=spalloc(n,1,1);
Bh_plus(end)=si_plus/(h^2);
% Loesen des Gleichungssystems:
Y_plus=-L_plus\Bh_plus;
