
% Bemerkung:
% man könnte die Funktion f auch direkt hier definieren, z.B. via
% f = @(t,y) [y(2); -3*y(1)];
% dann könnte man später beim expliziten RKV auch f statt @f als Input schreiben


% Aufgabe 4.5 (b)
clear
clc
dbstop if error

% RK ABC von Dopri 5
A = [ 0,0,0,0,0,0;
      1/5, 0,0,0,0,0;
      3/40, 9/40,0,0,0,0;
      44/45, -56/15, 32/9, 0,0,0;
      19372/6561, -25360/2187, 64448/6561, -212/729,0,0;
      9017/3168, -355/33, 46732/5247, 49/176, -5103/18656,0];

b = [35/384; 0; 500/1113; 125/192; -2187/6784; 11/84];
c = [0; 1/5; 3/10; 4/5; 8/9; 1];

% Startwerte:
y0=[0.8;0];
t0=0;

% Deklarationen:
f_rel=zeros(10,1);
T=1;
y_von_1= y(T); % Werte einmalig die Lösungsfunktion des AWPs am Endzeitpunkt aus

% Bestimme h_i Vektor
h=zeros(10,1);
for i = 1:10
    h(i)=2^(-i);
end

% Berechnung der Approximationen an y(1) mit den verschiednen
% Schrittweiten h(i), i=1,...,10: 
for i = 1:10 
    
    % Berechnung der Approx.:
    [t,y] = expl_Runge_Kutta_Verfahren(t0,y0,h(i),@f,T,A,b,c); %@f -> Funktion handle
    
    %hier werden die relativen Fehler berechnet:
    f_rel(i)= norm(y(:,end)-y_von_1);
    
end

%Plot der Norm des absoluten Fehlers gegen die Schrittweite h (in loglog)
% Ebendso enthalten: h^5 über h, um die Konsistenzordnung zu veranschaulichen
loglog(h,f_rel,'*',h,h.^5,'diamond');
legend('DOPRI5','h^5','location','NorthWest');
title('Fehlerplot')
ylabel('Norm des absoluten Fehlers')
xlabel('Schrittweite h')
