function [ti,yi] = expl_Runge_Kutta_Verfahren(t0,y0,h,f,T,A,b,c)
% [ti,yi] diskreter Loesungsgraph des AWPs y=f(y), y(to)=y0
% auf dem Intervall [t0,T]
%
% A,b,c <--- Buchter-Parameter des expl. RKVs


% Initialisierung:
ti=t0:h:T; % Zeitgitter
s=max(size(b));  % s ist die Stufenzahl des Verfahrens
N=length(ti); % Anzahl der Zeitschritte
d=max(size(y0)); % Dimension des AWPs
eta=zeros(d,s); % die Vektoren eta_j als Spalten einer Matrix
yi=zeros(d,N); % Loesungsvektor (Approximationen an die Lsg. y)

yi(:,1)=y0; % Startwert

for i=1:N-1 % Iterationsschritte des impliziten RKVs
    for j=1:s
        
        % sukzessive Berechnung der eta_j's:
        sum=zeros(size(y0));
        for l=1:j-1
            sum=sum+A(j,l)*f(ti(i)+c(l)*h,eta(:,l));
        end
        eta(:,j)=yi(:,i)+h*sum;
    end
    
    % Endauswertung eines RKV-Schrittes
    sum=zeros(size(y0));
    for k=1:s
        sum=sum+b(k)*f(ti(i)+c(k)*h,eta(:,k));
    end
    yi(:,i+1)=yi(:,i)+h*sum;
end