
function [xi,yi] = Milne_Simpson(t0,y0,h,f,fy,T,Version)

%m=2;

% Beta Koeffizienten
beta_1=1/3; beta_2=4/3; beta_3=1/3;
BETA=[beta_1;beta_2;beta_3];
% Dimension des AWP
d=max(size(y0));
% Zeitgitter
xi=t0:h:T;
% Anzahl Zeitschritte
L=length(xi);

% Führe wieder initialen Schritt mit einem expliziten Einschrittverfahren aus
if Version==1
    % A_1, b_1, c_1 aus Aufgabe 5.2b
    A=[0 0 0 0;1/2 0 0 0;0 1/2 0 0; 0 0 1 0];
    b=[1/6 2/6 2/6 1/6]'; c=[0 1/2 1/2 1]';
    [~,yi_tmp]=expl_Runge_Kutta_Verfahren(t0,y0,h,f,t0+h,A,b,c);
    y1=yi_tmp(:,end);
else
    %A=1/2; b=1; c=1/2; - Verfahren von Runge
    A=[0 0; 1/2 0]; b=[0 1]'; c=[0 1/2];
    [~,yi_tmp]=expl_Runge_Kutta_Verfahren(t0,y0,h,f,t0+h,A,b,c);
    y1=yi_tmp(:,end);
end

% Schreibe/initialisiere yi Matrix
yi=[y0, y1, zeros(max(size(y0)),L-2)];

% Eigentliches Mehrschrittverfahren
for i=2:(L-1)
    yk=yi(:,i);
    % Newton-Verfahren
    continue_loop = 1;
    count = 0;
    while continue_loop
        
        N = (yi(:,i-1)+h*[f(xi(i-1),yi(:,i-1)), f(xi(i),yi(:,i)), f(xi(i+1),yk)]*BETA-yk);
        Nprime = (h*beta_3*fy(xi(i+1),yk)-eye(d));
        
        yk=yk-Nprime\N;
        
        count = count +1;
                
        if norm(N)<10^(-8) % eigentlicher Newtonabbruch
            continue_loop = 0;
        end
        
        if count > 100 % alternativer Newtonabbruch
            error('Newton iteration seems to not converge!')
        end
    end
    yi(:,i+1)=yk;
end
