% Beispielimplementierung zu Aufgabe 8.3

function []= Blatt8()
clear all; close all; clc;

% Startwerte:
y0=[0.8;0];
t0=0;
T=1;

h = (1/2).^(1:10); % Schrittweiten

% Exact solution at T
y_von_1= y(T);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% (a)
% Deklarationen:
err=zeros(2,10);

% Berechnung der Approximationen an y(T) mit den verschiednen
% Schrittweiten h(i), i=1,...,10: 
for i = 1:10 
    
    % Berechnung der Approx. mit den verschiedenen Verfahren:
    [~,y1] = linear_impl_Euler(t0,y0,h(i),@f,@fy,T);
    [~,y2] = linear_impl_midpoint(t0,y0,h(i),@f,@fy,T);
    
    %hier werden die relativen Fehler berechnet:
    err(1,i)= norm(y1(:,end)-y_von_1);
    err(2,i)= norm(y2(:,end)-y_von_1);
   
end

%Plot der Norm des absoluten Fehlers gegen die Schrittweite h (in loglog):
figure;
loglog(h,err(1,:),'-+',h,err(2,:),'-o',h,h,':',h,h.^2,':');
legend('linear impl. Euler','linear impl. Mittelpunktregel','h','h^2','location','NorthWest');
title('Fehlerplot')
ylabel('Norm des absoluten Fehlers')
xlabel('Schrittweite h')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Aufgabe 8.3 (b) und (c)

% Deklarationen:
err=zeros(3,10);

% Berechnung der Approximationen an y(T) mit den verschiednen
% Schrittweiten h(i), i=1,...,10: 
for i = 1:10 
        
    % Berechnung der Approx. mit den verschiedenen Verfahren:
    [~,y1] = Adams_Bashforth(t0,y0,h(i),@f,T);
    [~,y2] = Milne_Simpson(t0,y0,h(i),@f,@fy,T,1);
    [~,y3] = Milne_Simpson(t0,y0,h(i),@f,@fy,T,2);
    
    %hier werden die relativen Fehler berechnet:
    err(1,i)= norm(y1(:,end)-y_von_1);
    err(2,i)= norm(y2(:,end)-y_von_1);
    err(3,i)= norm(y3(:,end)-y_von_1);
    
end

%Plot der Norm des absoluten Fehlers gegen die Schrittweite h (in loglog):
figure;
loglog(h,err(1,:),h,err(2,:),h,err(3,:),h,h.^2,':',h,h.^3,':',h,h.^4,':');
legend('y_1 mit Adams Bashforth ','y_1 mit Milne Simpson und dem RKV mit A1,b1,c1 aus A 5.2b','y_1 mit Milne Simpson und dem Verfahren von Runge','h^2','h^3','h^4','location','NorthWest');
title('Fehlerplot: Adams-Bashforth bzw. Milne-Simpson (m=2)')
ylabel('Norm des absoluten Fehlers')
xlabel('Schrittweite h')

end