
function [xi,yi] = Adams_Bashforth(t0,y0,h,f,T)

%m = 2;

% Zeitgitter
xi=t0:h:T;
% Anzahl Zeitschritte
L=length(xi);

% Bestimme ersten Schritt mit Verfahren von Runge
A=[0 0; 1/2 0]; b=[0 1]'; c=[0 1/2]; % Tableau
[~,yi_tmp]=expl_Runge_Kutta_Verfahren(t0,y0,h,f,t0+h,A,b,c); % Alter Routine um einen Schritt auszuführen (T = t0+h)
y1=yi_tmp(:,end); % yi_tmp(:,t0+h)

% Schreibe/initialisiere yi Matrix
yi=[y0, y1, zeros(max(size(y0)),L-2)];

% Eigentliches Mehrschrittverfahren
for i=2:(L-1)
    yi(:,i+1)=yi(:,i)+h*((3/2)*f(xi(i),yi(:,i))-(1/2)*f(xi(i-1),yi(:,i-1)));
end
