% Beispielimplementierung zu Aufgabe 7.4

function []= Aufgabe_7_4()
clear all; close all; clc;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% (a)
N=50;
n=1:1:N;
for k=n
    e=ones(k,1);
    A=k^2*spdiags([e -2*e e],-1:1,k,k);
    min_e(k)= eigs(A,1,'sa');
end

figure;
plot(n,min_e)
grid on
xlabel('N')
ylabel('min eig(A)')
title('The smallest (most negative) eigenvalue of A')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% (b) See below
% (c) Plot at t=0.03

T=2;
x0=0;
xend=1;
alpha=1;
t_plot=0.03;

g=@(x) 0.0+1.0*(x>=1/4 & x<=3/4);


hx=0.05;

% discretize x-axis
x=x0:hx:xend;

% create matrix A
M=length(x);
e=ones(M-2,1);
A=spdiags([e -2*e e],-1:1,M-2,M-2);
A=A*alpha/(hx^2);

%--------------------
% different time steps
h=[0.001 0.0015 0.003 0.03];

for l=1:length(h)
    
    [t,x,u_imp] = ImpEuler(T,h(l),hx,g,A);
    [t,x,u_midpoint] = Midpoint(T,h(l),hx,g,A);
    
    figure(l+1);
    hold on
    
    factor = t_plot/h(l) +1;
    if  l<=2
        [t,x,u_exp] = ExpEuler(T,h(l),hx,g,A);
        plot(x,u_exp(:,factor));
    end
    plot(x,u_imp(:,factor));
    plot(x,u_midpoint(:,factor));
    
    switch l
        case 1
            legend('Explicit Euler','Implicit Euler','Midpoint rule')
            title('h=0.001');
        case 2
            legend('Explicit Euler','Implicit Euler','Midpoint rule')
            title('h=0.0015');
        case 3
            legend('Implicit Euler','Midpoint rule')
            title('h=0.003')
        otherwise
            legend('Implicit Euler','Midpoint rule')
            title('h=0.03')
    end
end

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% (b)
function [t,x,u] = ExpEuler(T,h,hx,g,A)

t0=0;
x0=0;
xend=1;


t=t0:h:T; % Initialisierung des Zeitgitters
l=length(t);

x=x0:hx:xend;
M=length(x);

u=zeros(M,l);
for i=1:M
    u(i,1)=g(x(i));
end


Ah=h*A;
Id = speye(size(A)); % identity matrix has the same size with A

for i=1:l-1
    % u(i+1)=(Id+hA)*u(i)
    u(2:end-1,i+1)=(Id+Ah)*u(2:end-1,i);
end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [t,x,u] = ImpEuler(T,h,hx,g,A)

t0=0;
x0=0;
xend=1;

t=t0:h:T; % Initialisierung des Zeitgitters
l=length(t);

x=x0:hx:xend;
M=length(x);

u=zeros(M,l);
for i=1:M
    u(i,1)=g(x(i));
end

Ah=h*A;
Id = speye(size(A)); % identity matrix has the same size with A

for i=1:l-1
    u(2:end-1,i+1)=(Id-Ah)\u(2:end-1,i);
end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [t,x,u] = Midpoint(T,h,hx,g,A)

t0=0;
x0=0;
xend=1;

t=t0:h:T; % Initialisierung des Zeitgitters
l=length(t);

x=x0:hx:xend;
M=length(x);

u=zeros(M,l);
for i=1:M
    u(i,1)=g(x(i));
end

Ah=h*A;
Id = speye(size(A));
inverse=inv(Id-Ah/2);

for i=1:l-1
   u(2:end-1,i+1)=(Id+Ah*inverse)*u(2:end-1,i);
end
end

