% Beispielimplementierung zu Aufgabe 7.1
% To plot the stability region, we plot |R(z)|= 1


function []= Aufgabe_7_1()
clear all; close all; clc;

if 0
% Plot using implicit plot command ezplot
% We plot |R(z)|^2-1=0, where z=x+iy
% Notice that this only works provided you have bought a symbolic toolbox
syms x y
figure(1);
ezplot(((x^2-y^2)/2+x+1)^2+(x*y+y)^2-1)
axis([-2.5 0.5 -2 2])
title('Stability region Runge')
xlabel('Re(\lambda h)');
ylabel('Im(\lambda h)');
end


if 1
% Plot using root command
% We plot R(z)=exp(it) as t ranges from 0 to 2pi
figure(2);
t=linspace(0,2*pi,100);
for j=1:length(t)
    p=[1/2 1 1-exp(i*t(j))];
    plot(roots(p),'x');
    hold on
end
axis([-2.5 0.5 -2 2])
title('Stability region Runge')
xlabel('Re(\lambda h)');
ylabel('Im(\lambda h)');
end


if 1
% Plot using contour command
% We plot a level curve of |R(z)| at 1 
figure(3);
[X,Y]=meshgrid(-2.5:0.01:0.5,-2:0.01:2);
Z=X+i*Y;
R=Z.^2/2+Z+1;
Rhat=abs(R);
contour(X,Y,Rhat,[1 1]);
title('Stability region Runge')
xlabel('Re(\lambda h)');
ylabel('Im(\lambda h)');
end

if 1
% Plot stability region Runge method
clear all
x=-2.5:0.01:0.5;
y=-2:0.01:2;
f=@(x,y) abs(1+(x+i*y)+(x+i*y)^2/2);

for m=1:length(x)
    for n=1:length(y)
        if f(x(m),y(n))<1
            z(n,m)=1;
        else
            z(n,m)=NaN;
        end
    end
end

figure(4);
imagesc(x,y,z);%stability region
title('Runge Method');
xlabel('Re(\lambda h)');
ylabel('Im(\lambda h)');
end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if 1
% Plot implicit midpoint rule using root command
% R(z) = exp(it) implies z=2*i*tan(i*t/2);
t=linspace(0,2*pi,100);
figure(5);
for j=1:length(t)
    p=[1 2*(exp(i*t(j))-1)/(exp(i*t(j))+1)];
    plot(roots(p),'x');
    hold on
end
axis([-0.5 0.5 -0.5 0.5])
title('Stability region implicit midpoint rule')
xlabel('Re(\lambda h)');
ylabel('Im(\lambda h)');
end


if 1
% Plot stabibility region implicit midpoint rule
clear all
x=-0.5:0.01:0.5;
y=-0.5:0.01:0.5;
f=@(x,y) abs((1+(x+i*y)/2)/(1-(x+i*y)/2));

for m=1:length(x)
    for n=1:length(y)
        if f(x(m),y(n))<=1
            z(n,m)=1;
        else
            z(n,m)=0;
        end
    end
end

figure(6);
imagesc(x,y,z);%stability region
title('Implicit Midpoint rule');
xlabel('Re(\lambda h)');
ylabel('Im(\lambda h)');
end


end
