% Beispielimplementierung zu Aufgabe 5.4

function []= A_5_4()
clear all; close all; clc;

% Aufgabe 5.4 (b)

% Erstellen von A, b1, b2 und c:
A1 = zeros(4,4); A1(2,1)=1/2; A1(3,2)=1/2; A1(4,3)=1;
b1=[1/6;2/6;2/6;1/6;0]; c1 = [0;1/2;1/2;1];
A2 = zeros(5,5); A2(1:4,1:4)=A1; A2(5,:)=[b1'];
b2 = [1/6;2/6;2/6;0;1/6]; c = [c1;1];

% f
f=@(t,Y)[1+Y(1,:).^2.*Y(2,:)-4*Y(1,:); 3*Y(1,:)-Y(1,:).^2.*Y(2,:)];

% Startwerte:
y0=[1.01;3];
t0=0;
T=20;

%Vorgaben:
h=1; tol=10^(-5); tau=0.9; p=3;

[ti,hat_yi] = RKV_expl_embedded(A2,b2,b1,c,f,y0,t0,T,1,tol,tau,p);


oben  = subplot(2,1,1);
unten = subplot(2,1,2);

% Plot der Graphen:
plot(oben,ti,hat_yi(1,:),ti,hat_yi(2,:));
maalegend(oben, 'y1','y2');
title( oben ,'Approximation des Graphen von y_1 und y_2');
xlabel(oben, 'Zeit ti');
ylabel(oben, 'y_i');
axis(oben,[0 20 0 7]);


t1=ti(1:end-1);
t2=ti(2:end);
hi=t2-t1;
l=length(hi);

% Plot der Schrittweiten:
plot(unten,ti(1:end-1),hi,'+'); 
title( unten,'Plot der Schritweiten hi gegen ti');
xlabel(unten, 'Schritt i');
ylabel(unten, 'hi');
axis(unten,[0 20 0 0.4]);
grid minor
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Aufgabe 5.4 (a)
function [ti,hat_yi] = RKV_expl_embedded(A,b1,b2,c,f,y0,t0,T,h0,tol,tau,p)

% Initialisierung mit der Startzeit (wird nach und nach um die Zeiten
% t_{i+1}=t_{i}+hi ergänzt)
ti=t0;
s=max(size(b1)); % Anzahl der Stufen des RKVs
d=max(size(y0)); % Dimesion des AWPs
eta=zeros(d,s); % eta_j's als Spalten der Matrix eta
% Initialisierung der Lösungsmatrix, die nach und nach um
% eine Spalte mit dem aktuellen hat_yi ergänzt wird:
hat_yi=zeros(d,1);
hat_yi(:,1)=y0; % Startwert

% Da hier die Anzahl der Schritte nicht von Begin an bekannt ist,
% wird eine while-Schleife benutzt:
i=1; % mit "i" werden die Schritte gezaehlt 
h=h0; % Startschrittweite
while(ti(i)<T)
    %-------------------------------------------------------
    % Berechnung der eta_j's:
    for j=1:s 
        sum=0;
        for l=1:j-1
            sum=sum+A(j,l)*f(ti(i)+c(l)*h,eta(:,l));
        end
        eta(:,j)=hat_yi(:,i)+h*sum;
    end
    %--------------------------------------------------------
    %--------------------------------------------------------
    % doppelte Endauswertung der RKV's
    % d.h. y_i->y_{i+1} und \hat y_i->\hat y_{i+1}
    hat_sum=0;
    sum=0;
    for k=1:s
        sum=sum+b1(k)*f(ti(i)+c(k)*h,eta(:,k));
        hat_sum=hat_sum+b2(k)*f(ti(i)+c(k)*h,eta(:,k));
    end
    yi=hat_yi(:,i)+h*sum;
    hat_yi_tmp=hat_yi(:,i)+h*hat_sum;
    %--------------------------------------------------------
    %--------------------------------------------------------
    % Berechnung des Fehlerschaetzers:
    delta=norm(yi-hat_yi_tmp);
    
    if delta>0 % Berechnug der neuen Schrittweite
        h=tau*((tol/delta)^(1/(p+1)))*h;
    else
       
        h=h0;
    end
    
    if delta<tol % Test ob der Schritt wiederholt werden muss
        i=i+1;
        ti=[ti ti(end)+h]; % Anhangen des nächsten Zeitpunkts
        hat_yi=[hat_yi hat_yi_tmp]; % Anhängen von \hat y_{i+1}
    end
    
end
end
