% Beispielimplementierung zu Aufgabe 5.3

function []= A_5_3()
clear all; close all; clc;
%RKV 1:
A1 = zeros(4,4); A1(2,1)=1/2; A1(3,2)=1/2; A1(4,3)=1;
b1=[1/6;2/6;2/6;1/6]; c1 = [0;1/2;1/2;1];

%RKV 2:
A2 = zeros(5,5); A2(1:4,1:4)=A1; A2(5,:)=[b1' 0];
b2 = [1/6;2/6;2/6;0;1/6]; c2 = [c1;1];

%RKV 3:
A3 = A2;
b3 = [b1;0]; c3=c2;


% Startwerte:
y0=[0.8;0];
t0=0;

f = @(t,y)[y(2);-3*y(1)];

% Exakte Loesung
y_exact = @(t) [0.8*cos(sqrt(3)*t);-0.8*sqrt(3)*sin(sqrt(3)*t)];

% Deklarationen:
f_rel=zeros(3,10);
T=1;
y_von_1= y_exact(1);


% Berechnung der Approximationen an y(1) mit den verschiednen
% Schrittweiten h(i), i=1,...,10: 
for i = 1:10 
    h(i)=2^(-i);
    % Berechnung der Approx. mit den verschiedenen Verfahren:
    [t1,y1] = expl_Runge_Kutta_Verfahren(t0,y0,h(i),f,T,A1,b1,c1);
    [t2,y2] = expl_Runge_Kutta_Verfahren(t0,y0,h(i),f,T,A2,b2,c2);
    [t3,y3] = expl_Runge_Kutta_Verfahren(t0,y0,h(i),f,T,A3,b3,c3);
    
    %hier werden die absoluten Fehler berechnet:
    f_rel(1,i)= norm(y1(:,end)-y_von_1);
    f_rel(2,i)= norm(y2(:,end)-y_von_1);
    f_rel(3,i)= norm(y3(:,end)-y_von_1);
   
end

%Plot der Norm des absoluten Fehlers gegen die Schrittweite h:
loglog(h,f_rel(1,:),'--g',h,f_rel(2,:),'r',h,f_rel(3,:),'+c',h,h.^3,':',h,h.^4,':');
legend('RKV1','RKV2','RKV3','h^3','h^4','location','NorthWest');
title('Fehlerplot')
ylabel('Norm des absoluten Fehlers')
xlabel('Schrittweite h')
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [ti,yi] = expl_Runge_Kutta_Verfahren(t0,y0,h,f,T,A,b,c)

ti=t0:h:T;
s=max(size(b));
N=length(ti);
d=max(size(y0));
eta=zeros(d,s);
yi=zeros(d,N);

yi(:,1)=y0;

for i=1:N-1
    for j=1:s
        sum=0;
        for l=1:j-1
            sum=sum+A(j,l)*f(ti(i)+c(l)*h,eta(:,l));
        end
        eta(:,j)=yi(:,i)+h*sum;
    end
    sum=0;
    for k=1:s
        sum=sum+b(k)*f(ti(i)+c(k)*h,eta(:,k));
    end
    yi(:,i+1)=yi(:,i)+h*sum;
end
end