% Aufgabe 11.4 (b)
% 2D heat equation on the unit square. Diffusion term =1

% alle Matrizen und Vektoren sind hier im sparse Format!

function [U] = Heat2D(u_0yt,u_1yt,u_x0t,u_x1t,u_xy0,T,h,tau,method)
% method=0: explicit Euler
% method=1: implicit Euler

%-------------------------------------------------

N=ceil(1/h)-1; % h=1/(n+1) bzw. n=1/h-1
Nt=ceil(T/tau)-1;

space=linspace(0,1,N+2);
time=linspace(0,1,Nt+2);

%------------------------------------------------

C=spdiags(repmat([1,-2,1],N,1), [-1 0 1], N,N);
A=(kron(speye(N),C)+kron(C,speye(N)))*tau/(h^2);

switch method
    case 0 % U^{k+1}=LU^k+Bk
        L=speye(N^2)+A;
        
        % create empty matrix to store solution
        V=zeros(N^2,Nt+2);
        U=zeros(N+2,N+2,Nt+2);
        
        % initial condition
        for i=1:N
            for j=1:N
                V(i+(j-1)*N,1)=u_xy0(i*h,j*h);
            end
        end
        
        for k=1:Nt+1
            % calculate Bk
            B=spalloc(N^2,1,4*N-4);
            
            for i=1:N
                B(i)=u_x0t(i*h,time(k));
                B((N-1)*N+i)=u_x1t(i*h,time(k));
                B((i-1)*N+1)=u_0yt(i*h,time(k));
                B((i-1)*N+N)=u_1yt(i*h,time(k));
                
            end
            B=B*tau/(h^2);
            % calculate U^{k+1}
            V(:,k+1)=L*V(:,k)+B;
        end
        % add boundary condition to U^{k+1}
        upper=zeros(1,N);
        lower=zeros(1,N);
        left=zeros(N+2,1);
        right=zeros(N+2,1);
        for k=0:Nt+1
            for i=1:N
                upper(i)=u_0yt(i*h,time(k+1));
                lower(i)=u_1yt(i*h,time(k+1));
            end
            for i=1:N+2
                left(i)=u_x0t(space(i),time(k+1));
                right(i)=u_x1t(space(i),time(k+1));
            end
            temp=reshape(V(:,k+1),N,N);
            temp=[upper;temp;lower];
            temp=[left temp right];
            U(:,:,k+1)=temp;
        end
        
    case 1
        % LU^{k+1}=U^k+B^{k+1}
        L=speye(N^2)-A;
        
        % create empty matrix to store solution
        V=zeros(N^2,Nt+2);
        U=zeros(N+2,N+2,Nt+2);
        
        % initial condition
        for i=1:N
            for j=1:N
                V(i+(j-1)*N,1)=u_xy0(i*h,j*h);
            end
        end
        
        for k=1:Nt+1
            % calculate B^{k+1}
            B=spalloc(N^2,1,4*N-4);
            
            for i=1:N
                B(i)=u_x0t(i*h,time(k+1));
                B((N-1)*N+i)=u_x1t(i*h,time(k+1));
                B((i-1)*N+1)=u_0yt(i*h,time(k+1));
                B((i-1)*N+N)=u_1yt(i*h,time(k+1));
                
            end
            B=B*tau/(h^2);
            % calculate U^{k+1}
            V(:,k+1)=L\(V(:,k)+B);
        end
        % add boundary condition to U^{k+1}
        upper=zeros(1,N);
        lower=zeros(1,N);
        left=zeros(N+2,1);
        right=zeros(N+2,1);
        for k=0:Nt+1
            for i=1:N
                upper(i)=u_0yt(i*h,time(k+1));
                lower(i)=u_1yt(i*h,time(k+1));
            end
            for i=1:N+2
                left(i)=u_x0t(space(i),time(k+1));
                right(i)=u_x1t(space(i),time(k+1));
            end
            temp=reshape(V(:,k+1),N,N);
            temp=[upper;temp;lower];
            temp=[left temp right];
            U(:,:,k+1)=temp;
        end
end

end
