% Aufgabe 11.4 (d)
clear all; close all; clc

% Die exakte Loesung:
u_ex=@(x,y,t)(cos(3*pi*x+7*pi)*cos(pi*y)*exp(-10*t));

% Initial condition
u_xy0=@(x,y)(cos(3*pi*x+7*pi)*cos(pi*y));

% Boundary conditions
u_0yt=@(y,t)(-cos(pi*y)*exp(-10*t));
u_1yt=@(y,t)(cos(pi*y)*exp(-10*t));
u_x0t=@(x,t)(cos(3*pi*x+7*pi)*exp(-10*t));
u_x1t=@(x,t)(-cos(3*pi*x+7*pi)*exp(-10*t));

% final time
T=0.2;

% meshsize
max=6;
Delta_x=zeros(max,1);
Delta_t=zeros(max,1);

for i=1:max
    Delta_x(i)=1/2^i;
    Delta_t(i)=1/2^(i+3);
end


[H,Tau]=meshgrid(Delta_x,Delta_t);

error_E=zeros(max); % Platz für die Fehler
error_I=zeros(max);



% find numerical solution
for n=1:length(Delta_t)
    for m=1:length(Delta_x)
        
        h=H(m,n);
        
        tau=Tau(m,n);
        N=ceil(1/h)-1; % h=1/(n+1) bzw. n=1/h-1
        space=linspace(0,1,N+2);

        
        U_Exp=Heat2D(u_0yt,u_1yt,u_x0t,u_x1t,u_xy0,T,h,tau,0);
        U_Imp=Heat2D(u_0yt,u_1yt,u_x0t,u_x1t,u_xy0,T,h,tau,1);
        
        clear U_ex
        U_ex=zeros(N+2,N+2);
        for i=1:N+2
            for j=1:N+2
                U_ex(i,j)=u_ex(space(i),space(j),T);
            end
        end

        E=U_Exp(:,:,end)-U_ex;
        I=U_Imp(:,:,end)-U_ex;
        error_E(m,n)=norm(U_Exp(:,:,end)-U_ex,Inf);
        error_I(m,n)=norm(U_Imp(:,:,end)-U_ex,Inf);
        
        

    end
end

% scale the error of Explicit method to get meaningful plot
error_Es=error_E;
for  n=1:length(Delta_t)
    for m=1:length(Delta_x)
        if (error_E(n,m)<10^(-2))
            error_Es(n,m)=10^(-2);
        end
        if (error_E(n,m)>10^2)
                error_Es(n,m)=10^2;
        end
    end
end

figure;
% plot t=h^2/4
h_axis=[1/2;1/4;1/8;1/16;1/32;1/64];
t_axis=[1/16;1/64;1/256;0.002;0.002;0.002];

z_axis=100*ones(6,1);

p=plot3(h_axis,t_axis,z_axis);
c = p.Color;
p.Color = 'red';
hold on  

% plot the Explicit error
surf(H,Tau,error_Es)
colorbar
shading interp
grid minor
view(2)
xlabel('h')
ylabel('tau')
title('Error Explicit Euler')


figure;
% plot the implicit Euler
surf(H,Tau,error_I)
colorbar
shading interp
grid minor
view(2)
xlabel('h')
ylabel('tau')
title('Error Implicit Euler')


