tic
% Aufgabe 11.4 (c)
clear all; close all; clc

% Die exakte Loesung:
u_ex=@(x,y,t)(cos(3*pi*x+7*pi)*cos(pi*y)*exp(-10*t));

% Initial condition
u_xy0=@(x,y) (cos(3*pi*x+7*pi)*cos(pi*y));

% Boundary conditions
u_0yt=@(y,t)(-cos(pi*y)*exp(-10*t));
u_1yt=@(y,t)(cos(pi*y)*exp(-10*t));
u_x0t=@(x,t)(cos(3*pi*x+7*pi)*exp(-10*t));
u_x1t=@(x,t)(-cos(3*pi*x+7*pi)*exp(-10*t));

% final time
T=0.1;

% spatial meshsize
h=0.01;
[X,Y]=meshgrid(0:h:1);

% temporal meshsize
tau=10.^[-5 -3];

% find numerical solution
for l=1:length(tau)
    U_Exp=Heat2D(u_0yt,u_1yt,u_x0t,u_x1t,u_xy0,T,h,tau(l),0);
    U_Imp=Heat2D(u_0yt,u_1yt,u_x0t,u_x1t,u_xy0,T,h,tau(l),1);

    figure(l);
    subplot(1,2,1)
    surf(X,Y,U_Exp(:,:,end))
    name=['Explicit Euler with time step tau=',num2str(tau(l))];
    title(name)
    name=['Implicit Euler with time step tau=',num2str(tau(l))];
    subplot(1,2,2)
    surf(X,Y,U_Imp(:,:,end))
    title(name)
end

runtime=toc
