% A10.4 (a)
function [U_h] = approx_U_h(f,b1,b2,b3,b4,n)

% Schrittweite
h=1/(n+1);

% F auswerten
F=zeros(n^2,1);
for i=1:n
    for j=1:n
        F(i+(j-1)*n)=f(i*h,j*h);
    end
end

% T als sparse matrix
T = spdiags(repmat([-1 2 -1],n,1),[-1 0 1],n,n);
% Ah sparse
Ah=(1/h)^2*(kron(speye(n),T)+kron(T,speye(n)));

% Ränder (bedenke, dass von unten links nach oben rechts gezählt wird)
% linker Rand
B1=-kron((b1(h:h:(n*h)))',[1;zeros(n-1,1)]);
% rechter Rand
B2=-kron((b2(h:h:(n*h)))',[zeros(n-1,1);1]);
% unterer Rand
B3=-[(b3(h:h:(n*h)))';zeros(((n-1)*n),1)];
% oberer Rand
B4=-[zeros(((n-1)*n),1);(b4(h:h:(n*h)))'];
% Randwerte zusammenbauen
Bh=(1/h)^2*(B1+B2+B3+B4);
% LGS lösen
U_h=Ah\(F-Bh);
